/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.container;

import dev.toma.gunsrpg.common.container.AbstractContainer;
import dev.toma.gunsrpg.common.entity.TurretEntity;
import dev.toma.gunsrpg.common.init.ModContainers;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;

public class TurretContainer
extends AbstractContainer {
    private final int entityId;
    private final IInventory inventory;

    public TurretContainer(ContainerType<? extends TurretContainer> type, int containerId, PlayerInventory playerInventory, int entityId, IInventory inventory) {
        super(type, containerId);
        this.entityId = entityId;
        this.inventory = inventory;
        Predicate<ItemStack> filter = this.getInputFilter(playerInventory.field_70458_d.field_70170_p);
        this.addSlots(inventory, 2, 4, 8, 8, 0, (inv, index, x, y) -> new AmmoSlot(inv, index, x, y, filter));
        this.addPlayerInventory(playerInventory, 97);
    }

    private TurretContainer(int containerId, PlayerInventory inventory, int entityId) {
        this((ContainerType<? extends TurretContainer>)((ContainerType)ModContainers.TURRET_CONTAINER.get()), containerId, inventory, entityId, TurretContainer.resolveInventory(inventory.field_70458_d.field_70170_p, entityId));
    }

    public TurretContainer(int containerId, PlayerInventory inventory, PacketBuffer buffer) {
        this(containerId, inventory, buffer.readInt());
    }

    public boolean func_75145_c(PlayerEntity player) {
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = this.func_75139_a(index);
        int size = this.inventory.func_70302_i_();
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (index < size ? !this.func_75135_a(slotStack, size, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, size, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return stack;
    }

    public int getEntityId() {
        return this.entityId;
    }

    private Predicate<ItemStack> getInputFilter(World world) {
        Entity entity = world.func_73045_a(this.entityId);
        if (!(entity instanceof TurretEntity)) {
            return t -> false;
        }
        return ((TurretEntity)entity).getAmmoFilter();
    }

    private static IInventory resolveInventory(World world, int entityId) {
        Entity entity = world.func_73045_a(entityId);
        if (!(entity instanceof TurretEntity)) {
            return new Inventory(8);
        }
        return ((TurretEntity)entity).getInventory();
    }

    private static final class AmmoSlot
    extends Slot {
        private final Predicate<ItemStack> filter;

        public AmmoSlot(IInventory inventory, int slotIndex, int xPos, int yPos, Predicate<ItemStack> filter) {
            super(inventory, slotIndex, xPos, yPos);
            this.filter = filter;
        }

        public boolean func_75214_a(ItemStack stack) {
            return this.filter.test(stack);
        }
    }
}

